<?xml version="1.0" encoding="utf-8"?>
<?xml-stylesheet href="chrome://global/skin/" type="text/css"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" encoding="utf-8" doctype-public="-//MOZILLA//DTD XUL V1.0//EN"/>

<xsl:template match="/Root">

<window xmlns:html="http://www.w3.org/1999/xhtml"
        xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
        xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"
        style="background:none"
        >


<hbox>

<vbox width="360">
<groupbox>
<caption label="System Summary"></caption>
  <grid>
    <columns>
      <column class="entry_row"/>
      <column flex="1"/>
    </columns>
    <rows>
      <row>
        <label>System:</label>
        <label><xsl:value-of select="Software/Item[@name='Computer System']/SystemType"/></label>
      </row>
      <row>
        <label>CPU:</label>
        <label><xsl:value-of select="Hardware/Item[@name='Processors']/Element/Name"/></label>
      </row>
      <row>
        <label>CPU Cores:</label>
        <label><xsl:value-of select="Software/Item[@name='Computer System']/NumberOfProcessors"/></label>
      </row>
      <row>
        <label>Main Board:</label>
        <label><xsl:value-of select="Hardware/Item[@name='Base board']/Product"/></label>
      </row>
      <row>
        <label>Memory:</label>
        <label><xsl:value-of select="Software/Item[@name='Computer System']/TotalPhysicalMemory"/> Bytes</label>
      </row>
      <row>
        <label>OS:</label>
        <label><xsl:value-of select="Software/Item[@name='Operating System']/Caption"/></label>
      </row>
    </rows>
  </grid>
</groupbox>
<spacer height="3"/>
<groupbox>
<caption label="MediaCoder Platform"></caption>
<vbox id="appinfo"/>
</groupbox>
</vbox>

<vbox width="320">
<groupbox flex="1">
<caption>
  <menulist oncommand="parentNode.nextSibling.selectedIndex=selectedIndex">
    <menupopup>
      <xsl:for-each select="Hardware/Item[@name='Processors']/Element">
      <menuitem>
          <xsl:attribute name="label"><xsl:value-of select="DeviceID"/></xsl:attribute>
      </menuitem>
      </xsl:for-each>
    </menupopup>
  </menulist>  
</caption>
<deck>
<xsl:for-each select="Hardware/Item[@name='Processors']/Element">
  <grid>
    <columns>
      <column class="entry_row"/>
      <column flex="1"/>
    </columns>
    <rows>
      <row>
        <label>Family:</label>
		<label><xsl:value-of select="Caption"/></label>
      </row>
      <row>
        <label>Clock:</label>
		<label><xsl:value-of select="CurrentClockSpeed"/> Mhz</label>
      </row>
    </rows>
  </grid>
</xsl:for-each>
</deck>
</groupbox>

<groupbox>
<caption label="Motherboard Board"/>
  <grid>
    <columns>
      <column class="entry_row"/>
      <column flex="1"/>
    </columns>
    <rows>
      <row>
        <label>Vendor:</label>
        <label><xsl:value-of select="Hardware/Item[@name='Base board']/Manufacturer"/></label>
      </row>
      <row>
        <label>BIOS:</label>
        <label><xsl:value-of select="Hardware/Item[@name='BIOS']/Name"/></label>
      </row>
    </rows>
  </grid>
</groupbox>

<groupbox>
<caption>
  <menulist oncommand="parentNode.nextSibling.selectedIndex=selectedIndex">
    <menupopup>
      <xsl:for-each select="Hardware/Item[@name='Physical Memory Banks']/Element">
      <menuitem>
          <xsl:attribute name="label"><xsl:value-of select="BankLabel"/></xsl:attribute>
      </menuitem>
      </xsl:for-each>
    </menupopup>
  </menulist>  
</caption>
<deck>
<xsl:for-each select="Hardware/Item[@name='Physical Memory Banks']/Element">
  <grid>
    <columns>
      <column class="entry_row"/>
      <column flex="1"/>
    </columns>
    <rows>
      <row>
        <label>Capacity:</label>
        <label><xsl:value-of select="Capacity"/> Bytes</label>
      </row>
      <row>
        <label>Speed:</label>
        <label><xsl:value-of select="Speed"/> MHz</label>
      </row>
    </rows>
  </grid>
</xsl:for-each>
</deck>
</groupbox>
</vbox>

</hbox>
</window>

</xsl:template>

</xsl:stylesheet>